document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.add-to-wishlist').forEach(function(button) {
        button.addEventListener('click', function() {
            const productId = button.dataset.product;
            const action = button.dataset.action;

            fetch(button.closest('form')?.dataset.wishlistUrl || prestashop.urls.base_url + 'module/wishlist/actions', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: `action=${action}&id_product=${productId}&ajax=1`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Updated wishlist!');
                } else {
                    alert('Error: ' + (data.error || 'Unknown'));
                }
            });
        });
    });
});