<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class Whishlist extends Module
{
    public function __construct()
    {
        $this->name = 'whishlist';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Hostana';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            'min' => '1.7.0.0',
            'max' => '8.99.99',
        ];
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->trans('Whishlist', [], 'Modules.Whishlist.Admin');
        $this->description = $this->trans('Module for a whishlist functionality', [], 'Modules.Whishlist.Admin');

        $this->confirmUninstall = $this->trans('Are you sure you want to uninstall?', [], 'Modules.Whishlist.Admin');

        if (!Configuration::get('WHISHLIST_MODULE_NAME')) {
            $this->warning = $this->trans('No name provided', [], 'Modules.Whishlist.Admin');
        }
    }

    public function autoload($className)
    {
        $path = dirname(__FILE__).'/classes/'.$className.'.php';
        if (file_exists($path)) {
            require_once $path;
        }
    }

    public function install()
    {
        spl_autoload_register([$this, 'autoload']);

        return parent::install()
            && $this->registerHook('displayProductAdditionalInfo')
            && $this->registerHook('header')
            && $this->installTab()
            && $this->createDatabase();
    }

    public function uninstall()
    {
        return parent::uninstall() && $this->dropDatabase();
    }

    public function createDatabase()
    {
        $sql = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."wishlist` (
            `id_wishlist` INT AUTO_INCREMENT PRIMARY KEY,
            `id_customer` INT NOT NULL,
            `id_product` INT NOT NULL,
            `date_add` DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE="._MYSQL_ENGINE_." DEFAULT CHARSET=utf8;";

        return Db::getInstance()->execute($sql);
    }

    public function dropDatabase()
    {
        return Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'wishlist`');
    }

    private function installTab()
    {
        $tab = new Tab();
        $tab->class_name = 'AdminWishlist'; // Svarbu
        $tab->module = $this->name;
        $tab->id_parent = (int) Tab::getIdFromClassName('IMPROVE'); // Arba pasirink kitą sekciją
        $tab->name = [];

        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = 'Wishlist';
        }

        return $tab->add();
    }

    public function hookHeader($params)
    {
        $this->context->controller->registerJavascript('module-wishlist-js', 'modules/'.$this->name.'/views/js/wishlist.js', ['position' => 'bottom', 'priority' => 150]);
        $this->context->controller->registerStylesheet('module-wishlist-css', 'modules/'.$this->name.'/views/css/wishlist.css');

        if ($this->context->customer->isLogged()) {
            require_once dirname(__FILE__).'/classes/WishlistManager.php';
            $manager = new WishlistManager();
            $products = $manager->getProducts($this->context->customer->id);

            $wishlistProductIds = array_map(function($item) {
                return (int) $item['id_product'];
            }, $products);
            $this->context->smarty->assign('wishlistProductIds', $wishlistProductIds);
        } else {
            $this->context->smarty->assign('wishlistProductIds', []);
        }
    }

    public function hookDisplayProductAdditionalInfo($params)
    {
        $product = (int) $params['product']['id_product']; 

        $this->context->smarty->assign([
            'id_product' => $product,
            'wishlist_url' => $this->context->link->getModuleLink('wishlist', 'actions'),
        ]);

        return $this->display(__FILE__, 'views/templates/front/add_to_wishlist_button.tpl');
    }


}